IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Turno_Validar_Producto') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Turno_Validar_Producto
END
GO

CREATE FUNCTION [dbo].[CF_Turno_Validar_Producto](@pId_Cliente INT, @pId_Turno BIGINT, @pId_Sector_Turno INT )
RETURNS VARCHAR(5000)
AS
BEGIN


DECLARE @Respuesta				VARCHAR(5000) 
DECLARE @Fecha					DATETIME
DECLARE @Id_Recurso				INT 
DECLARE @Id_Recurso_Horario		INT 
DECLARE @Flag_Producto_Valida	INT
DECLARE @Habilitado				INT
DECLARE @Id_Sector				SMALLINT
DECLARE @Id_Producto			VARCHAR(50)
DECLARE @Id_Sector_Deseado		SMALLINT

--===========================================================================================
SELECT	@Id_Recurso = ISNULL(Id_Recurso, 0),
		@Fecha		= Fecha,
		@Id_Recurso_Horario = ISNULL(Id_Recurso_Horario, 0)
FROM CRM_Turnos 
WHERE 
Id_Turno = @pId_Turno

--===========================================================================================
SELECT @Id_Sector_Deseado = ISNULL(Id_Sector, 0)
FROM Empresas_Sedes_Sec_Recursos
WHERE
Id_Recurso = @Id_Recurso

--===========================================================================================

IF(@Id_Sector_Deseado > 0) 
BEGIN
	SET @Flag_Producto_Valida = ISNULL((SELECT  MAX(1) FROM Empresas_Sedes_Sectores_Prod WHERE Id_Sector=@Id_Sector_Deseado),0)
	IF(@Flag_Producto_Valida=1)
	BEGIN

		SET @Habilitado=0
		
		DECLARE cur_Valida_Turno CURSOR FOR
		SELECT ISNULL(Id_producto, '')
		FROM Empresas_Sedes_Sectores_Prod
		WHERE
		Id_Sector = @Id_Sector_Deseado


		OPEN cur_Valida_Turno
		FETCH NEXT FROM cur_Valida_Turno INTO @Id_Producto
		WHILE @@FETCH_STATUS = 0
		BEGIN

		SET @Habilitado= dbo.CF_Item_Paid(@pId_Cliente, @Id_Producto, @Fecha) 

			IF(@Habilitado=1)
			BEGIN
				SET  @Respuesta = '' 
			BREAK
			END

		FETCH NEXT FROM cur_Valida_Turno INTO @Id_Producto
		END
		CLOSE cur_Valida_Turno
		DEALLOCATE cur_Valida_Turno


	END 



END

	IF(@Habilitado=0)
	BEGIN
		IF (@pId_Sector_Turno!=0)	
			BEGIN
				SET @Id_Producto= dbo.CF_Turno_Producto_Cobrar(@Id_Recurso_Horario,@pId_Sector_Turno)
			END 
			
		IF (@pId_Sector_Turno=0)	
			BEGIN
				SET @Id_Producto= dbo.CF_Turno_Producto_Cobrar(@Id_Recurso_Horario,@Id_Sector_Deseado)
			END
			
		SET @Respuesta= ISNULL(@Id_Producto,'')
	END

RETURN ISNULL(@Respuesta, '')
END
